/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.recipes;

import com.shynieke.statues.init.StatueRegistry;
import com.shynieke.statues.recipes.LootInfo;
import com.shynieke.statues.recipes.StatueLootInfo;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.RegistryObject;

public class StatueLootList {
    public static ArrayList<StatueLootInfo> lootList = new ArrayList();
    public static StatueLootInfo loot_info;

    public static void initializeStatueLoot() {
        StatueLootList.addLoot("baby_zombie", new ItemStack((ItemLike)Items.f_42583_), new ItemStack((ItemLike)Items.f_42749_), ItemStack.f_41583_);
        StatueLootList.addLoot("bee", ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42784_), ItemStack.f_41583_);
        StatueLootList.addLoot("blaze", new ItemStack((ItemLike)Items.f_42593_), new ItemStack((ItemLike)Items.f_42585_), ItemStack.f_41583_);
        StatueLootList.addLoot("chicken", new ItemStack((ItemLike)Items.f_42402_), new ItemStack((ItemLike)Items.f_42581_), ItemStack.f_41583_);
        StatueLootList.addLoot("chicken_jockey", new ItemStack((ItemLike)Items.f_42583_), new ItemStack((ItemLike)Items.f_42402_), ItemStack.f_41583_);
        StatueLootList.addLoot("king_cluck", new ItemStack((ItemLike)StatueRegistry.NUGGET.get()), ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42587_));
        StatueLootList.addLoot("cow", new ItemStack((ItemLike)Items.f_42579_), ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42454_));
        StatueLootList.addLoot("creeper", new ItemStack((ItemLike)Items.f_42403_), ItemStack.f_41583_, ItemStack.f_41583_);
        StatueLootList.addLoot("enderman", new ItemStack((ItemLike)StatueRegistry.PEBBLE.get(), 16), new ItemStack((ItemLike)Items.f_42584_), ItemStack.f_41583_);
        StatueLootList.addLoot("flood", ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_);
        StatueLootList.addLoot("ghast", new ItemStack((ItemLike)Items.f_42403_), ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42586_));
        StatueLootList.addLoot("guardian", new ItemStack((ItemLike)Items.f_42526_), new ItemStack((ItemLike)Items.f_42695_), new ItemStack((ItemLike)Items.f_42696_));
        StatueLootList.addLoot("husk", new ItemStack((ItemLike)Items.f_42583_), ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42416_));
        StatueLootList.addLoot("drowned", new ItemStack((ItemLike)Items.f_42583_), ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42417_));
        StatueLootList.addLoot("magma_slime", new ItemStack((ItemLike)Items.f_42542_), ItemStack.f_41583_, ItemStack.f_41583_);
        StatueLootList.addLoot("mooshroom", ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_);
        StatueLootList.addLoot("pig", ItemStack.f_41583_, ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42485_));
        StatueLootList.addLoot("rabbit", new ItemStack((ItemLike)Items.f_42649_), new ItemStack((ItemLike)Items.f_42697_), new ItemStack((ItemLike)Items.f_42648_));
        StatueLootList.addLoot("sheep_white", new ItemStack((ItemLike)Blocks.f_50041_), new ItemStack((ItemLike)Items.f_42658_), ItemStack.f_41583_);
        StatueLootList.addLoot("sheep_orange", new ItemStack((ItemLike)Blocks.f_50042_), new ItemStack((ItemLike)Items.f_42658_), ItemStack.f_41583_);
        StatueLootList.addLoot("sheep_magenta", new ItemStack((ItemLike)Blocks.f_50096_), new ItemStack((ItemLike)Items.f_42658_), ItemStack.f_41583_);
        StatueLootList.addLoot("sheep_light_blue", new ItemStack((ItemLike)Blocks.f_50097_), new ItemStack((ItemLike)Items.f_42658_), ItemStack.f_41583_);
        StatueLootList.addLoot("sheep_yellow", new ItemStack((ItemLike)Blocks.f_50098_), new ItemStack((ItemLike)Items.f_42658_), ItemStack.f_41583_);
        StatueLootList.addLoot("sheep_lime", new ItemStack((ItemLike)Blocks.f_50099_), new ItemStack((ItemLike)Items.f_42658_), ItemStack.f_41583_);
        StatueLootList.addLoot("sheep_pink", new ItemStack((ItemLike)Blocks.f_50100_), new ItemStack((ItemLike)Items.f_42658_), ItemStack.f_41583_);
        StatueLootList.addLoot("sheep_gray", new ItemStack((ItemLike)Blocks.f_50101_), new ItemStack((ItemLike)Items.f_42658_), ItemStack.f_41583_);
        StatueLootList.addLoot("sheep_light_gray", new ItemStack((ItemLike)Blocks.f_50102_), new ItemStack((ItemLike)Items.f_42658_), ItemStack.f_41583_);
        StatueLootList.addLoot("sheep_cyan", new ItemStack((ItemLike)Blocks.f_50103_), new ItemStack((ItemLike)Items.f_42658_), ItemStack.f_41583_);
        StatueLootList.addLoot("sheep_purple", new ItemStack((ItemLike)Blocks.f_50104_), new ItemStack((ItemLike)Items.f_42658_), ItemStack.f_41583_);
        StatueLootList.addLoot("sheep_blue", new ItemStack((ItemLike)Blocks.f_50105_), new ItemStack((ItemLike)Items.f_42658_), ItemStack.f_41583_);
        StatueLootList.addLoot("sheep_brown", new ItemStack((ItemLike)Blocks.f_50106_), new ItemStack((ItemLike)Items.f_42658_), ItemStack.f_41583_);
        StatueLootList.addLoot("sheep_green", new ItemStack((ItemLike)Blocks.f_50107_), new ItemStack((ItemLike)Items.f_42658_), ItemStack.f_41583_);
        StatueLootList.addLoot("sheep_red", new ItemStack((ItemLike)Blocks.f_50108_), new ItemStack((ItemLike)Items.f_42658_), ItemStack.f_41583_);
        StatueLootList.addLoot("sheep_black", new ItemStack((ItemLike)Blocks.f_50109_), new ItemStack((ItemLike)Items.f_42658_), ItemStack.f_41583_);
        StatueLootList.addLoot("sheep_shaven", ItemStack.f_41583_, ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42658_));
        StatueLootList.addLoot("slime", ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42518_), ItemStack.f_41583_);
        StatueLootList.addLoot("snow_golem", new ItemStack((ItemLike)Items.f_42452_), ItemStack.f_41583_, new ItemStack((ItemLike)Blocks.f_50133_));
        StatueLootList.addLoot("squid", ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42532_), ItemStack.f_41583_);
        StatueLootList.addLoot("villager", ItemStack.f_41583_, ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42616_));
        StatueLootList.addLoot("witch", new ItemStack((ItemLike)Items.f_42525_), new ItemStack((ItemLike)Items.f_42451_), new ItemStack((ItemLike)Items.f_42590_));
        StatueLootList.addLoot("wasteland_pig", new ItemStack((ItemLike)StatueRegistry.TEA.get()), StatueLootList.getWastelandBlock(), ItemStack.f_41583_);
        StatueLootList.addLoot("zombie", new ItemStack((ItemLike)Items.f_42583_), ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42416_));
        StatueLootList.addLoot("pufferfish", ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42529_), ItemStack.f_41583_);
        StatueLootList.addLoot("spider", new ItemStack((ItemLike)Items.f_42401_), new ItemStack((ItemLike)Items.f_42591_), ItemStack.f_41583_);
        StatueLootList.addLoot("evoker", ItemStack.f_41583_, ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42747_));
        StatueLootList.addLoot("etho", new ItemStack((ItemLike)StatueRegistry.MARSHMALLOW.get()), ItemStack.f_41583_, ItemStack.f_41583_);
        StatueLootList.addLoot("turtle", new ItemStack((ItemLike)Items.f_41867_), ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42399_));
    }

    public static ItemStack getWastelandBlock() {
        CompoundTag nbt;
        ItemStack wasteland = new ItemStack((ItemLike)Blocks.f_49992_).m_41714_((Component)new TextComponent("Wasteland Block").m_130940_(ChatFormatting.LIGHT_PURPLE));
        wasteland.m_41663_(Enchantments.f_44963_, 1);
        CompoundTag compoundTag = nbt = wasteland.m_41782_() ? wasteland.m_41783_() : new CompoundTag();
        if (nbt != null) {
            nbt.m_128405_("HideFlags", 1);
            wasteland.m_41751_(nbt);
        }
        return wasteland;
    }

    public static ItemStack getFloodBucket() {
        ItemStack floodBucket = new ItemStack((ItemLike)Items.f_42447_);
        floodBucket.m_41714_((Component)new TextComponent("The Flood").m_130940_(ChatFormatting.BLUE));
        return floodBucket;
    }

    public static void addLoot(String statue, LootInfo loot) {
        loot_info = new StatueLootInfo(statue, loot);
        if (!lootList.contains(loot_info)) {
            lootList.add(loot_info);
        }
    }

    public static void addLoot(String statue, ItemStack stack1, ItemStack stack2, ItemStack stack3) {
        LootInfo info = new LootInfo(stack1, stack2, stack3);
        StatueLootList.addLoot(statue, info);
    }

    public static void changeLoot(String statue, LootInfo loot) {
        if (!statue.isEmpty()) {
            for (int i = 0; i < lootList.size(); ++i) {
                StatueLootInfo oldLoot = lootList.get(i);
                if (!oldLoot.getStatue().equalsIgnoreCase(statue)) continue;
                lootList.set(i, new StatueLootInfo(oldLoot.getStatue(), loot));
            }
        }
    }

    public static StatueLootInfo getLootInfo(String statueName) {
        StatueLootInfo loot = new StatueLootInfo(statueName, LootInfo.EMPTY);
        for (StatueLootInfo info : lootList) {
            if (!info.getStatue().equalsIgnoreCase(statueName)) continue;
            loot = info;
        }
        return loot;
    }

    public static ArrayList<ItemStack> getStacksForStatue(String statue) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (StatueLootInfo info : lootList) {
            if (!info.getStatue().equals(statue)) continue;
            stacks.add(0, info.getStack1());
            stacks.add(1, info.getStack2());
            stacks.add(2, info.getStack2());
            if (stacks.get(0) != info.getStack1()) {
                stacks.set(0, info.getStack1());
            }
            if (stacks.get(1) != info.getStack2()) {
                stacks.set(1, info.getStack2());
            }
            if (stacks.get(2) == info.getStack3()) continue;
            stacks.set(2, info.getStack3());
        }
        return stacks;
    }

    public static ArrayList<Block> getBlockForStatue(String statue) {
        ArrayList<Block> blockList = new ArrayList<Block>();
        for (RegistryObject block : StatueRegistry.BLOCKS.getEntries()) {
            String blockName = ((Block)block.get()).m_7705_();
            if (blockName.isEmpty() || !blockName.contains(statue.replace("_", "")) || !blockName.contains("t3") && !blockName.contains("t4") || blockList.contains(block.get())) continue;
            blockList.add((Block)block.get());
        }
        return blockList;
    }
}

